###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_loss_functions_others.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_loss_functions_others.R".
##


###################################################
### code chunk number : Compare loss functions L(theta, a), 9 points, theta = 2
###################################################
## 
## Compare two loss functions:
## L_2(theta, a), L_s(theta, a)
## 
rm(list=ls(all=TRUE))

theta = 2
a = c(seq(1e-10, 2, by = 0.001), seq(2, 60, by = 10))
y1 = (a - theta)^2 # L_2(theta, a)
y2 = a / theta - log(a / theta) - 1 # L_s(theta, a)


# xp = c(1/5, 1/4, 1/3, 1/2, 1, 2, 3, 4, 5)
# ap = theta * xp
# y1p = (ap - theta)^2 # L_2(theta, a)
# y2p = ap / theta - log(ap / theta) - 1 # L_s(theta, a)


dev.new()
col = c("red", "blue")
lty = 1:2
# pch = c(4, 3, 2, 1, 0, 1, 2, 3, 4)
ylim = c(0, 30) ## range(y1, y2)
opar <- par(mar = c(5, 5, 4, 2))
plot(a, y1, type = "n", ylim = ylim, xlab = "a", ylab = expression( L(theta, a) ))
lines(a, y1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y2, lty = lty[2], col = col[2], lwd = 4)
# points(ap, y1p, pch = pch, col = col[1], lwd = 2)
# points(ap, y2p, pch = pch, col = col[2], lwd = 2)
leg.txt = c(expression( L[2](theta, a) ), expression( L[s](theta, a) ))
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
par(opar)
savePlot(filename = "figure/L_2_L_s", type = c("pdf"))
savePlot(filename = "figure/L_2_L_s", type = c("jpg"))


####################################################
### code chunk number : Simulations: 1 theta, not good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 2     ## hyperparameter
beta = 2      ## hyperparameter
v = 5          ## hyperparameter

n = 1000

theta = 1 / rgamma(n = 1, shape = alpha, scale = beta); theta
x = 1 / rgamma(n, shape = v, scale = theta) ## the sample

#### Moment estimators
## Moment_estimators_EX_EX2_EX3_new() is the best
alpha_1_beta_1_v_1_EX_VarX_EX3 = Moment_estimators(x); alpha_1_beta_1_v_1_EX_VarX_EX3
alpha_1_beta_1_v_1_EX_EX2_EX3 = Moment_estimators_EX_EX2_EX3(x); alpha_1_beta_1_v_1_EX_EX2_EX3
alpha_1_beta_1_v_1_EX_EX2_EX3_new = Moment_estimators_EX_EX2_EX3_new(x); alpha_1_beta_1_v_1_EX_EX2_EX3_new
 

#### MLE estimators
p = alpha_1_beta_1_v_1_EX_EX2_EX3_new
alpha_2_beta_2_v_2 = Newtons(fun = moment_fun, y = p)$root;alpha_2_beta_2_v_2


####################################################
### code chunk number : Simulations: n theta, good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(1)
alpha = 2            ## hyperparameter
beta = 2             ## hyperparameter
v = 5                ## hyperparameter
n = 1000           ## sample size

theta = 1 / rgamma(n, shape = alpha, scale = beta)
x = 1 / rgamma(n, shape = v, scale = theta) ## the sample

#### Moment estimators
## Moment_estimators_EX_EX2_EX3_new() is the best
alpha_1_beta_1_v_1_EX_VarX_EX3 = Moment_estimators(x); alpha_1_beta_1_v_1_EX_VarX_EX3
alpha_1_beta_1_v_1_EX_EX2_EX3 = Moment_estimators_EX_EX2_EX3(x); alpha_1_beta_1_v_1_EX_EX2_EX3
alpha_1_beta_1_v_1_EX_EX2_EX3_new = Moment_estimators_EX_EX2_EX3_new(x); alpha_1_beta_1_v_1_EX_EX2_EX3_new
 
#### MLE estimators
p = alpha_1_beta_1_v_1_EX_EX2_EX3_new
alpha_2_beta_2_v_2 = Newtons(fun = moment_fun, y = p)$root; alpha_2_beta_2_v_2

